import {
    Container,
    Section,
    Table
} from 'react-bulma-components'

type PreviousWordsProps = {
    show: boolean
    words: Array<string>
}

function PreviousWords(props: PreviousWordsProps) {
    let sectionStyle = {display: 'none'}
    if (props.show) {
        sectionStyle.display = 'block'
    }

    const tbody = props.words.map((word: string) => {
        return (
            <tr>
                <td>{word}</td>
                <td>{word.at(0)?.toUpperCase()}</td>
            </tr>
        )
    })

    return (
        <Section style={sectionStyle}>
            <Container>
                <h2 className="title is-4">Tidigare ord</h2>
                <Table size="fullwidth">
                    <thead>
                        <tr>
                            <th>Ord</th>
                            <th>Första bokstaven</th>
                        </tr>
                    </thead>
                    <tbody>
                        {tbody}
                    </tbody>
                </Table>
            </Container>
        </Section>
    )
}

export default PreviousWords